/**
 *  Main onload handler
 */
 window.addEventListener('load', function(){

    TweenLite.ticker.useRAF(false);
    TweenLite.lagSmoothing(0);

    resetAnimation();

});


function resetAnimation() {

	TweenLite.set((".txt1,.txt2,.txt3"), { opacity: 0, y: 20 });

	TweenLite.set(("#loader"), {opacity:1 });
	TweenLite.set((".txt4"), {boxShadow:"inset 0px 0px 0px 100px #f2b30f"});
	startAnimation();

}

function startAnimation(  ){

    let curloop = 0;
    let maxloop = 2;
    let tl = new TimelineLite({

        paused: true,
        onComplete: function() {
            tl.restart();
        }
    });
	  tl

	// .to(".element", delay, { style, position, animation-style }, "time")
		.to("#loader", .6, { opacity: 0, ease: Expo.easeIn}, "0")
	    .to(".txt1", .5, { opacity: 1, y: 0, ease: Expo.easeOut}, "-=1")
		.to(".txt1", .5, { opacity: 0, y: -20, ease: Expo.easeIn}, "+=1")
		.to(".txt2", .5, { opacity: 1, y: 0, ease: Expo.easeOut}, "=0")
		.to(".txt2", .5, { opacity: 0, y: -20, ease: Expo.easeIn}, "+=.7")
		.to(".txt3", .5, { opacity: 1, y: 0, ease: Expo.easeOut}, "+=0")
		.to(".txt3", .5, { opacity: 0, y: -20, ease: Expo.easeIn}, "+=1")
		.to(".txt4", .5, { opacity: 1, y: 0, ease: Expo.easeOut}, "+=0")
		.to(".shadow", .5, { boxShadow:"inset 0px 0px 0px 0px #f2b30f", ease: Linear.easeNone }, "-=0.5")


		let outro = new TimelineLite();
    outro
        .to("#loader", .6, { opacity: 1, ease: Expo.easeIn}, "+=1")
        .delay(1);

    tl.call(function() {
        curloop++;
        if (curloop > maxloop) {
            tl.stop();
        }
    }, null, null, 7);
    tl.add(outro, 8);

    tl.restart();

}