/**
 *  Main onload handler
 */
 window.addEventListener('load', function(){

    TweenLite.ticker.useRAF(false);
    TweenLite.lagSmoothing(0);

    resetAnimation();

});


function resetAnimation() {

	TweenLite.set((".txt1,.txt2,.txt3"), { opacity: 0 });

	TweenLite.set(("#loader"), {opacity:1 });
	TweenLite.set((".txt4"), {boxShadow:"inset 0px 0px 0px 100px #f3b503"});
	startAnimation();

}

function startAnimation(  ){

    let curloop = 0;
    let maxloop = 2;
    let tl = new TimelineLite({

        paused: true,
        onComplete: function() {
            tl.restart();
        }
    });
	  tl

	// .to(".element", delay, { style, position, animation-style }, "time")
		.to("#loader", .6, { opacity: 0, ease: Expo.easeIn}, "0")
        .to(".txt1", .5, { opacity: 1, ease: Expo.easeOut}, "-=.5")
	    .to(".bg1", .5, { opacity: 0, ease: Expo.easeOut}, "+=1")
	    .to(".bg2", .5, { opacity: 0, ease: Expo.easeOut}, "+=.5")
        .to(".bg3", .5, { opacity: 0, ease: Expo.easeOut}, "+=.5")
        .to(".bg4", .5, { opacity: 0, ease: Expo.easeOut}, "+=.5")
        .to(".bg5", .5, { opacity: 0, ease: Expo.easeOut}, "+=.5")
        //.to(".bg6", .9, { opacity: 0, ease: Expo.easeOut}, "+=.5")

		.to(".txt1", .5, { opacity: 0, ease: Expo.easeIn}, "-=.2")
		.to(".txt4", 0, { opacity: 1, ease: Expo.easeOut}, "-=0")
		.to(".shadow", .5, { boxShadow:"inset 0px 0px 0px 0px #f3b503", ease: Linear.easeNone }, "-=.2")


		let outro = new TimelineLite();
    outro
        .to("#loader", .6, { opacity: 1, ease: Expo.easeIn}, "+=0.5")
        .delay(1);

    tl.call(function() {
        curloop++;
        if (curloop > maxloop) {
            tl.stop();
        }
    }, null, null, 7);
    tl.add(outro, 9.5);

    tl.restart();

}